 ; Ŀ
 ;   Tdi - reset the Tdindwg system variable.                              
 ;   Copyright 2003 by Rocket Software Ltd.                                
 ;   Written with no knowledge of its intended purpose.                    
 ; 

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   a list of the (possibly modified) target string and the number of     
 ;   changes made.                                                         
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug end.                                                             
 ; 

 ; Ŀ
 ;   Tdi.                                                                  
 ; 
 (DEFUN C:TDI (/ pref dnam namm len fn)
  (setvar "cmdecho" 0)
  (setq pref (getvar "dwgprefix"))
  (setq dnam (getvar "dwgname"))
  (setq namm (strcat pref dnam))
  (if (= (substr (strcase dnam t) (- (setq len (strlen dnam)) 3)) ".dwg")
      (setq dnam (substr dnam 1 (- len 4))))
 ; Ŀ
 ;   Replace backslashes in the file name with double backslashes.         
 ; 
  (setq namm (car (chug "\\" "\\\\" namm)))
; (command ".wblock" (strcat pref "zxzxzx") "" "0,0" "all" "")
; (command "oops")
  (command "qsave")
  (setq fn (open (strcat pref "new.scr") "w"))
  (write-line "(command \"new\" \".\")" fn)
  (write-line (strcat "(command \"-insert\" \"" namm "\" \"0,0\" \"1\" \"\" \"\")") fn)
  (write-line "(command \".zoom\" \"e\")" fn)
  (write-line "(command \"explode\" \"l\")" fn)
  (write-line (strcat "(command \"purge\" \"b\" \"" dnam "\" \"n\")") fn)
  (write-line (strcat "(command \".saveas\" \"\" \"" namm "\" \"y\")") fn)
  (close fn)
  (command "script" "new")
 (princ))